/*
 * Decompiled with CFR 0.152.
 */
package com.cyvack.crystal_clear.common.creative_tab;

import com.cyvack.crystal_clear.common.CrystalClear;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ItemVisibilityHandler {
    private static final Set<Item> INVISIBLE_ITEMS = new HashSet<Item>();
    public static final CrystalClearDisplay DISPLAY_INSTANCE = new CrystalClearDisplay();

    public static boolean isInvisible(Item item) {
        return INVISIBLE_ITEMS.contains(item);
    }

    public static <B extends Block, R> NonNullUnaryOperator<BlockBuilder<B, R>> makeInvisible() {
        return builder -> (BlockBuilder)builder.onRegisterAfter(Registries.f_256913_, b -> INVISIBLE_ITEMS.add(b.m_5456_()));
    }

    public static <B extends Item, R> NonNullUnaryOperator<ItemBuilder<B, R>> makeItemInvisible() {
        return builder -> (ItemBuilder)builder.onRegisterAfter(Registries.f_256913_, b -> INVISIBLE_ITEMS.add(b.m_5456_()));
    }

    public static <B extends Block, R> NonNullUnaryOperator<BlockBuilder<B, R>> makeInvisible(Supplier<Boolean> visibiltySup) {
        return builder -> (BlockBuilder)builder.onRegisterAfter(Registries.f_256913_, arg_0 -> ItemVisibilityHandler.lambda$makeInvisible$4((Supplier)visibiltySup, arg_0));
    }

    private static /* synthetic */ void lambda$makeInvisible$4(Supplier visibiltySup, Block b) {
        if (((Boolean)visibiltySup.get()).booleanValue()) {
            INVISIBLE_ITEMS.add(b.m_5456_());
        }
    }

    public static class CrystalClearDisplay
    implements CreativeModeTab.DisplayItemsGenerator {
        public void m_257865_(@NotNull CreativeModeTab.ItemDisplayParameters parameters, @NotNull CreativeModeTab.Output out) {
            ArrayList<ItemStack> visibleItems = new ArrayList<ItemStack>();
            for (RegistryEntry registeredItem : CrystalClear.getRegistrate().getAll(Registries.f_256913_)) {
                if (ItemVisibilityHandler.isInvisible((Item)registeredItem.get())) continue;
                visibleItems.add(((Item)registeredItem.get()).m_7968_());
            }
            out.m_246601_(visibleItems);
        }
    }
}

